/*
 * Decompiled with CFR 0.152.
 */
package fr.rader.timeless.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class TimelessConfig {
    private static final File CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("timeless.json").toFile();
    private static TimelessConfig instance;
    private static Gson gson;
    public boolean useOldWorldMenu = true;
    public boolean disableHitDirection = true;
    public boolean doPistonClunk = true;
    public boolean skeletonShootPurpleArrow = true;
    public boolean useOldInventoryLayout = true;
    public boolean enablePotionGlint = true;
    public boolean useOldPotionColors = true;
    public boolean useOldWindowIcons = true;
    public boolean useOldBatModel = true;
    public boolean useOldScreenBackground = true;

    public void write() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Timeless config file", e);
        }
    }

    public static TimelessConfig get() {
        if (instance == null) {
            gson = new Gson();
            if (!CONFIG_PATH.exists()) {
                instance = new TimelessConfig();
                instance.write();
            } else {
                try (FileReader reader = new FileReader(CONFIG_PATH);){
                    instance = (TimelessConfig)gson.fromJson((Reader)reader, TimelessConfig.class);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read Timeless config file", e);
                }
            }
        }
        return instance;
    }
}

