/*
 * Decompiled with CFR 0.152.
 */
package espy.ldu.events;

import espy.ldu.LocalDifficultyUtilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ChunkTaskManager
implements ServerTickEvents.EndTick {
    private static final Map<UUID, TaskState> activeTasks = new HashMap<UUID, TaskState>();

    public static void startTask(UUID playerId, class_2168 source, class_3218 world, List<class_1923> chunks, int time) {
        activeTasks.remove(playerId);
        source.method_45068((class_2561)class_2561.method_43470((String)("Starting inhabited time update for " + chunks.size() + " chunks...")));
        activeTasks.put(playerId, new TaskState(source, world, chunks, time));
    }

    public static boolean cancel(UUID playerId, class_2168 source) {
        if (activeTasks.containsKey(playerId)) {
            activeTasks.remove(playerId);
            source.method_45068((class_2561)class_2561.method_43470((String)"Inhabited time update cancelled."));
            return true;
        }
        source.method_45068((class_2561)class_2561.method_43470((String)"No active inhabited time update to cancel."));
        return false;
    }

    public void onEndTick(MinecraftServer server) {
        Iterator<TaskState> it = activeTasks.values().iterator();
        while (it.hasNext()) {
            TaskState task = it.next();
            task.tick();
            if (!task.isComplete()) continue;
            it.remove();
        }
    }

    static class TaskState {
        private final class_2168 source;
        private final class_3218 world;
        private final List<class_1923> chunks;
        private final int time;
        private int index = 0;
        private int updated = 0;

        TaskState(class_2168 source, class_3218 world, List<class_1923> chunks, int time) {
            this.source = source;
            this.world = world;
            this.chunks = chunks;
            this.time = time;
        }

        void tick() {
            int batchSize = LocalDifficultyUtilities.CONFIG.serverConfig.regionBatchSize;
            int i = 0;
            while (i < batchSize && this.index < this.chunks.size()) {
                class_1923 pos = this.chunks.get(this.index);
                class_2818 chunk = this.world.method_14178().method_12126(pos.field_9181, pos.field_9180, false);
                if (chunk != null) {
                    chunk.method_12028((long)this.time);
                    chunk.method_12008(true);
                    ++this.updated;
                }
                ++i;
                ++this.index;
            }
            int percent = (int)((float)this.index / (float)this.chunks.size() * 100.0f);
            this.source.method_45068((class_2561)class_2561.method_43470((String)("Progress: " + percent + "% (" + this.updated + "/" + this.chunks.size() + ")")));
            if (this.isComplete()) {
                this.source.method_45068((class_2561)class_2561.method_43470((String)("Done! Updated inhabited time for " + this.updated + " chunks.")));
            }
        }

        boolean isComplete() {
            return this.index >= this.chunks.size();
        }
    }
}

