/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins;

import com.ishland.vmp.common.config.Config;
import com.ishland.vmp.common.logging.AsyncAppenderBootstrap;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class VMPMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        Config.init();
        AsyncAppenderBootstrap.boot();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.carpet.")) {
            return FabricLoader.getInstance().isModLoaded("carpet");
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.playerwatching.optimize_nearby_entity_tracking_lookups")) {
            return Config.USE_OPTIMIZED_ENTITY_TRACKING;
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.networking.eventloops.")) {
            return Config.USE_MULTIPLE_NETTY_EVENT_LOOPS;
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.chunk.loading.portals.")) {
            return Config.USE_ASYNC_PORTALS;
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.chunk.iteration.")) {
            return Config.USE_OPTIMIZED_CHUNK_TICKING_ITERATION;
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.chunk.loading.async_chunk_on_player_login")) {
            return Config.USE_ASYNC_CHUNKS_ON_LOGIN && !VMPMixinPlugin.isClassExist("com.ishland.c2me.opts.chunkio.common.async_chunk_on_player_login.IAsyncChunkPlayer");
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.chunk.loading.command")) {
            return Config.USE_ASYNC_CHUNKS_ON_SOME_COMMANDS;
        }
        if (mixinClassName.equals("com.ishland.vmp.mixins.playerwatching.MixinTACSCancelSendingKrypton")) {
            return FabricLoader.getInstance().isModLoaded("krypton");
        }
        if (mixinClassName.startsWith("com.ishland.vmp.mixins.networking.avoid_deadlocks")) {
            return !FabricLoader.getInstance().isModLoaded("raknetify");
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static boolean isClassExist(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

