/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCtmProperties;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class StandardOverlayQuadProcessor
extends AbstractQuadProcessor {
    @Nullable
    protected Set<class_2960> matchTilesSet;
    @Nullable
    protected Predicate<class_2680> matchBlocksPredicate;
    @Nullable
    protected Set<class_2960> connectTilesSet;
    @Nullable
    protected Predicate<class_2680> connectBlocksPredicate;
    protected ConnectionPredicate connectionPredicate;
    protected int tintIndex;
    @Nullable
    protected class_2680 tintBlock;
    protected RenderMaterial material;

    public StandardOverlayQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, @Nullable Set<class_2960> matchTilesSet, @Nullable Predicate<class_2680> matchBlocksPredicate, @Nullable Set<class_2960> connectTilesSet, @Nullable Predicate<class_2680> connectBlocksPredicate, ConnectionPredicate connectionPredicate, int tintIndex, @Nullable class_2680 tintBlock, BlendMode layer) {
        super(sprites, processingPredicate);
        this.matchTilesSet = matchTilesSet;
        this.matchBlocksPredicate = matchBlocksPredicate;
        this.connectTilesSet = connectTilesSet;
        this.connectBlocksPredicate = connectBlocksPredicate;
        this.connectionPredicate = connectionPredicate;
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.material = RenderUtil.findOverlayMaterial(layer, this.tintBlock);
        for (int i = 0; i < sprites.length; ++i) {
            class_1058 sprite = sprites[i];
            if (!TextureUtil.isMissingSprite(sprite)) continue;
            sprites[i] = null;
        }
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        class_2350 lightFace = quad.lightFace();
        OverlayEmitter emitter = this.getEmitter(blockView, appearanceState, state, pos, lightFace, sprite, DirectionMaps.getMap(lightFace)[0], context);
        if (emitter != null) {
            context.addEmitterConsumer(emitter);
        }
        return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
    }

    protected boolean appliesOverlay(class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        if (!otherState.method_26234((class_1922)blockView, otherPos)) {
            return false;
        }
        if (this.connectBlocksPredicate != null && !this.connectBlocksPredicate.test(otherAppearanceState)) {
            return false;
        }
        if (this.connectTilesSet != null && !this.connectTilesSet.contains(SpriteCalculator.getSprite(otherAppearanceState, face).method_45851().method_45816())) {
            return false;
        }
        return !this.connectionPredicate.shouldConnect(blockView, appearanceState, state, pos, otherAppearanceState, otherState, otherPos, face, quadSprite);
    }

    protected boolean hasSameOverlay(@Nullable class_2680 otherAppearanceState, class_2350 face) {
        if (otherAppearanceState == null) {
            return false;
        }
        if (this.matchBlocksPredicate != null && !this.matchBlocksPredicate.test(otherAppearanceState)) {
            return false;
        }
        return this.matchTilesSet == null || this.matchTilesSet.contains(SpriteCalculator.getSprite(otherAppearanceState, face).method_45851().method_45816());
    }

    protected boolean appliesOverlayCorner(class_2350 dir0, class_2350 dir1, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2350 lightFace, class_1058 quadSprite) {
        mutablePos.method_25505((class_2382)pos, dir0).method_10098(dir1);
        class_2680 otherState = blockView.method_8320((class_2338)mutablePos);
        class_2680 otherAppearanceState = otherState.getAppearance(blockView, (class_2338)mutablePos, lightFace, state, pos);
        if (this.appliesOverlay(otherAppearanceState, otherState, (class_2338)mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
            mutablePos.method_10098(lightFace);
            return !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return false;
    }

    protected OverlayEmitter fromTwoSidesAdj(OverlayEmitter emitter, @Nullable class_2680 appearanceState0, @Nullable class_2680 appearanceState1, class_2350 dir0, class_2350 dir1, int sprite, int spriteC01, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2350 lightFace, class_1058 quadSprite) {
        this.prepareEmitter(emitter, lightFace, blockView, pos);
        emitter.addSprite(this.sprites[sprite]);
        if ((this.hasSameOverlay(appearanceState0, lightFace) || this.hasSameOverlay(appearanceState1, lightFace)) && this.appliesOverlayCorner(dir0, dir1, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
            emitter.addSprite(this.sprites[spriteC01]);
        }
        return emitter;
    }

    protected OverlayEmitter fromOneSide(OverlayEmitter emitter, @Nullable class_2680 appearanceState0, @Nullable class_2680 appearanceState1, @Nullable class_2680 appearanceState2, class_2350 dir0, class_2350 dir1, class_2350 dir2, int sprite, int spriteC01, int spriteC12, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2350 lightFace, class_1058 quadSprite) {
        boolean c12;
        boolean c01;
        if (this.hasSameOverlay(appearanceState1, lightFace)) {
            c01 = true;
            c12 = true;
        } else {
            c01 = this.hasSameOverlay(appearanceState0, lightFace);
            c12 = this.hasSameOverlay(appearanceState2, lightFace);
        }
        this.prepareEmitter(emitter, lightFace, blockView, pos);
        emitter.addSprite(this.sprites[sprite]);
        if (c01 && this.appliesOverlayCorner(dir0, dir1, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
            emitter.addSprite(this.sprites[spriteC01]);
        }
        if (c12 && this.appliesOverlayCorner(dir1, dir2, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
            emitter.addSprite(this.sprites[spriteC12]);
        }
        return emitter;
    }

    protected static OverlayEmitter getEmitter(ProcessingDataProvider dataProvider) {
        return dataProvider.getData(ProcessingDataKeys.STANDARD_OVERLAY_EMITTER_POOL).get();
    }

    protected void prepareEmitter(OverlayEmitter emitter, class_2350 face, class_1920 blockView, class_2338 pos) {
        emitter.prepare(face, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.material);
    }

    protected OverlayEmitter prepareEmitter(OverlayEmitter emitter, class_2350 face, class_1920 blockView, class_2338 pos, int sprite0) {
        this.prepareEmitter(emitter, face, blockView, pos);
        emitter.addSprite(this.sprites[sprite0]);
        return emitter;
    }

    protected OverlayEmitter prepareEmitter(OverlayEmitter emitter, class_2350 face, class_1920 blockView, class_2338 pos, int sprite0, int sprite1) {
        this.prepareEmitter(emitter, face, blockView, pos);
        emitter.addSprite(this.sprites[sprite0]);
        emitter.addSprite(this.sprites[sprite1]);
        return emitter;
    }

    @Nullable
    protected OverlayEmitter getEmitter(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2350 lightFace, class_1058 quadSprite, class_2350[] directions, ProcessingDataProvider dataProvider) {
        class_2680 appearanceState3;
        class_2680 appearanceState2;
        class_2680 appearanceState1;
        class_2680 appearanceState0;
        class_2338.class_2339 mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS);
        int applications = 0;
        mutablePos.method_25505((class_2382)pos, directions[0]).method_10098(lightFace);
        if (!blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos)) {
            mutablePos.method_25505((class_2382)pos, directions[0]);
            class_2680 state0 = blockView.method_8320((class_2338)mutablePos);
            appearanceState0 = state0.getAppearance(blockView, (class_2338)mutablePos, lightFace, state, pos);
            if (this.appliesOverlay(appearanceState0, state0, (class_2338)mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
                applications |= 1;
            }
        } else {
            appearanceState0 = null;
        }
        mutablePos.method_25505((class_2382)pos, directions[1]).method_10098(lightFace);
        if (!blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos)) {
            mutablePos.method_25505((class_2382)pos, directions[1]);
            class_2680 state1 = blockView.method_8320((class_2338)mutablePos);
            appearanceState1 = state1.getAppearance(blockView, (class_2338)mutablePos, lightFace, state, pos);
            if (this.appliesOverlay(appearanceState1, state1, (class_2338)mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
                applications |= 2;
            }
        } else {
            appearanceState1 = null;
        }
        mutablePos.method_25505((class_2382)pos, directions[2]).method_10098(lightFace);
        if (!blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos)) {
            mutablePos.method_25505((class_2382)pos, directions[2]);
            class_2680 state2 = blockView.method_8320((class_2338)mutablePos);
            appearanceState2 = state2.getAppearance(blockView, (class_2338)mutablePos, lightFace, state, pos);
            if (this.appliesOverlay(appearanceState2, state2, (class_2338)mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
                applications |= 4;
            }
        } else {
            appearanceState2 = null;
        }
        mutablePos.method_25505((class_2382)pos, directions[3]).method_10098(lightFace);
        if (!blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos)) {
            mutablePos.method_25505((class_2382)pos, directions[3]);
            class_2680 state3 = blockView.method_8320((class_2338)mutablePos);
            appearanceState3 = state3.getAppearance(blockView, (class_2338)mutablePos, lightFace, state, pos);
            if (this.appliesOverlay(appearanceState3, state3, (class_2338)mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite)) {
                applications |= 8;
            }
        } else {
            appearanceState3 = null;
        }
        return switch (applications) {
            case 15 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 8);
            case 7 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 5);
            case 11 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 6);
            case 13 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 13);
            case 14 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 12);
            case 5 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 9, 7);
            case 10 -> this.prepareEmitter(StandardOverlayQuadProcessor.getEmitter(dataProvider), lightFace, blockView, pos, 1, 15);
            case 3 -> this.fromTwoSidesAdj(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState2, appearanceState3, directions[2], directions[3], 4, 14, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 6 -> this.fromTwoSidesAdj(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState3, appearanceState0, directions[3], directions[0], 3, 16, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 12 -> this.fromTwoSidesAdj(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState0, appearanceState1, directions[0], directions[1], 10, 2, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 9 -> this.fromTwoSidesAdj(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState1, appearanceState2, directions[1], directions[2], 11, 0, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 1 -> this.fromOneSide(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState1, appearanceState2, appearanceState3, directions[1], directions[2], directions[3], 9, 0, 14, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 2 -> this.fromOneSide(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState2, appearanceState3, appearanceState0, directions[2], directions[3], directions[0], 1, 14, 16, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 4 -> this.fromOneSide(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState3, appearanceState0, appearanceState1, directions[3], directions[0], directions[1], 7, 16, 2, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 8 -> this.fromOneSide(StandardOverlayQuadProcessor.getEmitter(dataProvider), appearanceState0, appearanceState1, appearanceState2, directions[0], directions[1], directions[2], 15, 2, 0, mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
            case 0 -> {
                boolean c30;
                boolean s0 = this.hasSameOverlay(appearanceState0, lightFace);
                boolean s1 = this.hasSameOverlay(appearanceState1, lightFace);
                boolean s2 = this.hasSameOverlay(appearanceState2, lightFace);
                boolean s3 = this.hasSameOverlay(appearanceState3, lightFace);
                boolean c01 = s0 | s1 && this.appliesOverlayCorner(directions[0], directions[1], mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
                boolean c12 = s1 | s2 && this.appliesOverlayCorner(directions[1], directions[2], mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
                boolean c23 = s2 | s3 && this.appliesOverlayCorner(directions[2], directions[3], mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
                boolean v1 = c30 = s3 | s0 && this.appliesOverlayCorner(directions[3], directions[0], mutablePos, blockView, appearanceState, state, pos, lightFace, quadSprite);
                if (c01 | c12 | c23 | c30) {
                    OverlayEmitter emitter = StandardOverlayQuadProcessor.getEmitter(dataProvider);
                    this.prepareEmitter(emitter, lightFace, blockView, pos);
                    if (c01) {
                        emitter.addSprite(this.sprites[2]);
                    }
                    if (c12) {
                        emitter.addSprite(this.sprites[0]);
                    }
                    if (c23) {
                        emitter.addSprite(this.sprites[14]);
                    }
                    if (c30) {
                        emitter.addSprite(this.sprites[16]);
                    }
                    yield emitter;
                }
                yield null;
            }
            default -> throw new IllegalStateException("Unexpected value: " + applications);
        };
    }

    public static class OverlayEmitter
    implements Consumer<QuadEmitter> {
        protected static final class_1058[] EMPTY_SPRITES = new class_1058[4];
        protected class_1058[] sprites = new class_1058[4];
        protected int spriteAmount;
        protected class_2350 face;
        protected int color;
        protected RenderMaterial material;

        @Override
        public void accept(QuadEmitter emitter) {
            for (int i = 0; i < this.spriteAmount; ++i) {
                QuadUtil.emitOverlayQuad(emitter, this.face, this.sprites[i], this.color, this.material);
            }
        }

        public void prepare(class_2350 face, int color, RenderMaterial material) {
            System.arraycopy(EMPTY_SPRITES, 0, this.sprites, 0, EMPTY_SPRITES.length);
            this.spriteAmount = 0;
            this.face = face;
            this.color = color;
            this.material = material;
        }

        public void addSprite(@Nullable class_1058 sprite) {
            if (sprite != null) {
                this.sprites[this.spriteAmount++] = sprite;
            }
        }
    }

    public static class OverlayEmitterPool {
        protected final List<OverlayEmitter> list = new ObjectArrayList();
        protected int nextIndex = 0;

        public OverlayEmitter get() {
            if (this.nextIndex >= this.list.size()) {
                this.list.add(new OverlayEmitter());
            }
            OverlayEmitter emitter = this.list.get(this.nextIndex);
            ++this.nextIndex;
            return emitter;
        }

        public void reset() {
            this.nextIndex = 0;
        }
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardOverlayCtmProperties> {
        @Override
        public QuadProcessor createProcessor(StandardOverlayCtmProperties properties, class_1058[] sprites) {
            OverlayPropertiesSection overlaySection = properties.getOverlayPropertiesSection();
            return new StandardOverlayQuadProcessor(sprites, OverlayProcessingPredicate.fromProperties(properties), properties.getMatchTilesSet(), properties.getMatchBlocksPredicate(), properties.getConnectTilesSet(), properties.getConnectBlocksPredicate(), properties.getConnectionPredicate(), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public int getTextureAmount(StandardOverlayCtmProperties properties) {
            return 17;
        }

        @Override
        public boolean supportsNullSprites(StandardOverlayCtmProperties properties) {
            return false;
        }
    }
}

