/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl.dualsense;

import dev.isxander.controlify.driver.sdl.dualsense.DS5EffectsState;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class DualsenseTriggerEffects {
    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect off() {
        return new DS5EffectsState.TriggerEffect(EffectType.OFF, new byte[0]);
    }

    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect feedback(@Range(from=0L, to=9L) byte position, @Range(from=0L, to=8L) byte strength) {
        Validate.inclusiveBetween((long)0L, (long)9L, (long)position, (String)"Position must be between 0 and 9 inclusive");
        Validate.inclusiveBetween((long)0L, (long)8L, (long)strength, (String)"Strength must be between 0 and 8 inclusive");
        if (strength > 0) {
            byte forceValue = (byte)(strength - 1 & 7);
            int forceZones = 0;
            int activeZones = 0;
            for (int i = position; i < 10; ++i) {
                forceZones |= forceValue << 3 * i;
                activeZones = (char)(activeZones | (char)(1 << i));
            }
            return new DS5EffectsState.TriggerEffect(EffectType.FEEDBACK, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(forceZones & 0xFF), (byte)(forceZones >> 8 & 0xFF), (byte)(forceZones >> 16 & 0xFF), (byte)(forceZones >> 24 & 0xFF)});
        }
        return DualsenseTriggerEffects.off();
    }

    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect weapon(@Range(from=2L, to=7L) byte startPosition, @Range(from=3L, to=8L) byte endPosition, @Range(from=0L, to=8L) byte strength) {
        Validate.inclusiveBetween((long)2L, (long)7L, (long)startPosition, (String)"Start position must be between 2 and 7 inclusive");
        Validate.inclusiveBetween((long)(startPosition + 1), (long)8L, (long)endPosition, (String)"End position must be between start+1 and 8 inclusive");
        Validate.inclusiveBetween((long)0L, (long)8L, (long)strength, (String)"Strength must be between 0 and 8 inclusive");
        Validate.isTrue((startPosition < endPosition ? 1 : 0) != 0, (String)"Start position must be less than end position", (Object[])new Object[0]);
        if (strength > 0) {
            char startAndStopZones = (char)(1 << startPosition | 1 << endPosition);
            return new DS5EffectsState.TriggerEffect(EffectType.WEAPON, new byte[]{(byte)(startAndStopZones & 0xFF), (byte)(startAndStopZones >> 8 & 0xFF), (byte)(strength - 1)});
        }
        return DualsenseTriggerEffects.off();
    }

    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect vibration(@Range(from=0L, to=9L) byte position, @Range(from=0L, to=8L) byte amplitude, byte frequency) {
        Validate.inclusiveBetween((long)0L, (long)9L, (long)position, (String)"Position must be between 0 and 9 inclusive");
        Validate.inclusiveBetween((long)0L, (long)8L, (long)amplitude, (String)"Amplitude must be between 0 and 8 inclusive");
        if (amplitude > 0 && frequency > 0) {
            byte strengthValue = (byte)(amplitude - 1 & 7);
            int amplitudeZones = 0;
            int activeZones = 0;
            for (int i = position; i < 10; ++i) {
                amplitudeZones |= strengthValue << 3 * i;
                activeZones = (char)(activeZones | (char)(1 << i));
            }
            return new DS5EffectsState.TriggerEffect(EffectType.VIBRATION, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(amplitudeZones & 0xFF), (byte)(amplitudeZones >> 8 & 0xFF), (byte)(amplitudeZones >> 16 & 0xFF), (byte)(amplitudeZones >> 24 & 0xFF), 0, 0, frequency});
        }
        return DualsenseTriggerEffects.off();
    }

    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect feedbackMultiplePosition(@Range(from=0L, to=9L) byte @NotNull [] strength) {
        Validate.notNull((Object)strength, (String)"Strength array must not be null", (Object[])new Object[0]);
        Validate.isTrue((strength.length == 10 ? 1 : 0) != 0, (String)"Strength array must have 10 elements", (Object[])new Object[0]);
        boolean allZero = true;
        for (int i = 0; i < 10; ++i) {
            allZero &= strength[i] == 0;
            Validate.inclusiveBetween((long)0L, (long)8L, (long)strength[i], (String)"Strength i=%s must be between 0 and 8 inclusive".formatted(i));
        }
        if (!allZero) {
            int forceZones = 0;
            int activeZones = 0;
            for (int i = 0; i < 10; ++i) {
                byte strengthValue = strength[i];
                if (strengthValue <= 0) continue;
                byte forceValue = (byte)(strengthValue - 1 & 7);
                forceZones |= forceValue << 3 * i;
                activeZones = (char)(activeZones | (char)(1 << i));
            }
            return new DS5EffectsState.TriggerEffect(EffectType.FEEDBACK, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(forceZones & 0xFF), (byte)(forceZones >> 8 & 0xFF), (byte)(forceZones >> 16 & 0xFF), (byte)(forceZones >> 24 & 0xFF)});
        }
        return DualsenseTriggerEffects.off();
    }

    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect feedbackSlope(@Range(from=0L, to=8L) byte startPosition, @Range(from=1L, to=9L) byte endPosition, @Range(from=1L, to=8L) byte startStrength, @Range(from=1L, to=8L) byte endStrength) {
        Validate.inclusiveBetween((long)0L, (long)8L, (long)startPosition, (String)"Start position must be between 0 and 8 inclusive");
        Validate.inclusiveBetween((long)(startPosition + 1), (long)9L, (long)endPosition, (String)"End position must be between start+1 and 9 inclusive");
        Validate.inclusiveBetween((long)1L, (long)8L, (long)startStrength, (String)"Start strength must be between 1 and 8 inclusive");
        Validate.inclusiveBetween((long)1L, (long)8L, (long)endStrength, (String)"End strength must be between 1 and 8 inclusive");
        Validate.isTrue((startPosition < endPosition ? 1 : 0) != 0, (String)"Start strength must be less than end position", (Object[])new Object[0]);
        byte[] strength = new byte[10];
        float gradient = (float)(endStrength - startStrength) / (float)(endPosition - startPosition);
        for (int i = startPosition; i < 10; ++i) {
            strength[i] = i <= endPosition ? (byte)Math.round((float)startStrength + gradient * (float)(i - startPosition)) : endStrength;
        }
        return DualsenseTriggerEffects.feedbackMultiplePosition(strength);
    }

    @Contract(pure=true)
    public static DS5EffectsState.TriggerEffect vibrationMultiplePosition(byte frequency, @Range(from=0L, to=8L) byte @NotNull [] amplitude) {
        Validate.notNull((Object)amplitude, (String)"Amplitude array must not be null", (Object[])new Object[0]);
        Validate.isTrue((amplitude.length == 10 ? 1 : 0) != 0, (String)"Amplitude array must have 10 elements", (Object[])new Object[0]);
        if (frequency > 0) {
            boolean allZero = true;
            for (int i = 0; i < 10; ++i) {
                allZero &= amplitude[i] == 0;
                Validate.inclusiveBetween((long)0L, (long)8L, (long)amplitude[i], (String)"Amplitude i=%s must be between 0 and 8 inclusive".formatted(i));
            }
            if (!allZero) {
                int strengthZones = 0;
                int activeZones = 0;
                for (int i = 0; i < 10; ++i) {
                    byte amplitudeValue = amplitude[i];
                    if (amplitudeValue <= 0) continue;
                    byte strengthValue = (byte)(amplitudeValue - 1 & 7);
                    strengthZones |= strengthValue << 3 * i;
                    activeZones = (char)(activeZones | (char)(1 << i));
                }
                return new DS5EffectsState.TriggerEffect(EffectType.VIBRATION, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(strengthZones & 0xFF), (byte)(strengthZones >> 8 & 0xFF), (byte)(strengthZones >> 16 & 0xFF), (byte)(strengthZones >> 24 & 0xFF), 0, 0, frequency});
            }
        }
        return DualsenseTriggerEffects.off();
    }

    public static enum EffectType {
        OFF(5),
        FEEDBACK(33),
        WEAPON(37),
        VIBRATION(38),
        BOW(34),
        GALLOPING(35),
        MACHINE(39),
        SIMPLE_FEEDBACK(1),
        SIMPLE_WEAPON(2),
        SIMPLE_VIBRATION(3),
        LIMITED_FEEDBACK(17),
        LIMITED_WEAPON(18),
        DEBUG_FC(252),
        DEBUG_FD(253),
        DEBUG_FE(254);

        public final byte value;

        private EffectType(int value) {
            this.value = (byte)value;
        }
    }
}

