/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import dev.isxander.controlify.font.BindingFontHelper;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class GuideActionRenderer<T>
implements RenderComponent {
    private final GuideAction<T> guideAction;
    private final boolean rtl;
    private final boolean textContrast;
    private class_2561 bindingText;
    private int bindingTextWidth;
    private class_2561 name = null;

    public GuideActionRenderer(GuideAction<T> action, boolean rtl, boolean textContrast) {
        this.guideAction = action;
        this.rtl = rtl;
        this.textContrast = textContrast;
        this.bindingText = action.binding().inputIcon();
        this.bindingTextWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.bindingText);
    }

    @Override
    public void render(class_332 graphics, int x, int y, float deltaTime) {
        if (!this.isVisible()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_27525((class_5348)this.name);
        int bindingHeight = BindingFontHelper.getComponentHeight(font, (class_5348)this.bindingText);
        int n = y + bindingHeight / 2;
        Objects.requireNonNull(font);
        int centeredTextY = n - 9 / 2;
        if (!this.rtl) {
            graphics.method_51439(font, this.bindingText, x, centeredTextY, -1, false);
            x += this.bindingTextWidth + 4;
        }
        if (this.textContrast) {
            Objects.requireNonNull(font);
            graphics.method_25294(x - 1, centeredTextY - 1, x + textWidth + 1, centeredTextY + 9 + 1, Integer.MIN_VALUE);
        }
        graphics.method_51439(font, this.name, x, centeredTextY, -1, false);
        x += textWidth + 4;
        if (this.rtl) {
            graphics.method_51439(font, this.bindingText, x, centeredTextY, -1, false);
        }
    }

    @Override
    public Vector2ic size() {
        if (!this.isVisible()) {
            return new Vector2i();
        }
        class_327 font = class_310.method_1551().field_1772;
        int n = font.method_27525((class_5348)this.name) + 4 + this.bindingTextWidth;
        int n2 = BindingFontHelper.getComponentHeight(font, (class_5348)this.bindingText);
        Objects.requireNonNull(font);
        return new Vector2i(n, Math.max(n2, 9) + 2);
    }

    @Override
    public boolean isVisible() {
        return this.name != null && !this.guideAction.binding().isUnbound() && this.bindingText != null;
    }

    public void updateName(T ctx) {
        this.bindingText = this.guideAction.binding().inputIcon();
        this.bindingTextWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.bindingText);
        this.name = this.guideAction.name().supply(ctx).orElse(null);
    }
}

