/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.ingame.DualInput;
import net.minecraft.class_310;
import net.minecraft.class_743;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ControllerPlayerMovement
extends class_744 {
    private final ControllerEntity controller;
    private final class_746 player;
    private boolean wasFlying;
    private boolean wasPassenger;

    public ControllerPlayerMovement(ControllerEntity controller, class_746 player) {
        this.controller = controller;
        this.player = player;
    }

    public void method_3129(boolean slowDown, float movementMultiplier) {
        if (class_310.method_1551().field_1755 != null || this.player == null) {
            this.setMoveVec(0.0f, 0.0f);
            this.field_3910 = false;
            this.field_3909 = false;
            this.field_3908 = false;
            this.field_3906 = false;
            this.field_3904 = false;
            this.field_3903 = false;
            return;
        }
        float forwardImpulse = ControlifyBindings.WALK_FORWARD.on(this.controller).analogueNow() - ControlifyBindings.WALK_BACKWARD.on(this.controller).analogueNow();
        float leftImpulse = ControlifyBindings.WALK_LEFT.on(this.controller).analogueNow() - ControlifyBindings.WALK_RIGHT.on(this.controller).analogueNow();
        if (Controlify.instance().config().globalSettings().shouldUseKeyboardMovement()) {
            float threshold = ((InputComponent.Config)this.controller.input().orElseThrow().confObj()).buttonActivationThreshold;
            forwardImpulse = Math.abs(forwardImpulse) >= threshold ? Math.copySign(1.0f, forwardImpulse) : 0.0f;
            leftImpulse = Math.abs(leftImpulse) >= threshold ? Math.copySign(1.0f, leftImpulse) : 0.0f;
        }
        this.field_3910 = forwardImpulse > 0.0f;
        this.field_3909 = forwardImpulse < 0.0f;
        this.field_3908 = leftImpulse > 0.0f;
        boolean bl = this.field_3906 = leftImpulse < 0.0f;
        if (slowDown) {
            leftImpulse *= movementMultiplier;
            forwardImpulse *= movementMultiplier;
        }
        this.setMoveVec(forwardImpulse, leftImpulse);
        InputBinding jump = ControlifyBindings.JUMP.on(this.controller);
        if (jump.justPressed()) {
            this.field_3904 = true;
        }
        if (!jump.digitalNow()) {
            this.field_3904 = false;
        }
        InputBinding sneak = ControlifyBindings.SNEAK.on(this.controller);
        if (this.player.method_31549().field_7479 || this.player.method_5799() && !this.player.method_24828() || this.player.method_5854() != null || !this.controller.genericConfig().config().toggleSneak) {
            if (sneak.justPressed()) {
                this.field_3903 = true;
            }
            if (!sneak.digitalNow()) {
                this.field_3903 = false;
            }
        } else if (sneak.justPressed()) {
            boolean bl2 = this.field_3903 = !this.field_3903;
        }
        if (!this.player.method_31549().field_7479 && this.wasFlying && this.player.method_24828() || !this.player.method_5765() && this.wasPassenger) {
            this.field_3903 = false;
        }
        this.wasFlying = this.player.method_31549().field_7479;
        this.wasPassenger = this.player.method_5765();
    }

    private void setMoveVec(float forward, float left) {
        this.field_3905 = forward;
        this.field_3907 = left;
    }

    public static void updatePlayerInput(@Nullable class_746 player) {
        if (player == null) {
            return;
        }
        if (ControllerPlayerMovement.shouldBeControllerInput()) {
            player.field_3913 = new DualInput((class_744)new class_743(class_310.method_1551().field_1690), new ControllerPlayerMovement(Controlify.instance().getCurrentController().get(), player));
        } else if (!(player.field_3913 instanceof class_743)) {
            player.field_3913 = new class_743(class_310.method_1551().field_1690);
        }
    }

    public static void ensureCorrectInput(@Nullable class_746 player) {
        if (player == null) {
            return;
        }
        if (ControllerPlayerMovement.shouldBeControllerInput() && player.field_3913.getClass() == class_743.class) {
            ControllerPlayerMovement.updatePlayerInput(player);
        }
    }

    public static boolean shouldBeControllerInput() {
        return Controlify.instance().getCurrentController().isPresent() && Controlify.instance().currentInputMode().isController();
    }
}

