/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.fabrishot.capture;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import me.ramidzkh.fabrishot.capture.Dimension;
import me.ramidzkh.fabrishot.capture.FramebufferCapturer;
import me.ramidzkh.fabrishot.config.Config;
import me.ramidzkh.fabrishot.event.ScreenshotSaveCallback;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBIWriteCallbackI;
import org.lwjgl.stb.STBImageWrite;

public class FramebufferWriter {
    protected final FramebufferCapturer fbc;
    protected final Path file;

    public FramebufferWriter(Path file, FramebufferCapturer fbc) {
        this.file = file;
        this.fbc = fbc;
    }

    public void write() throws IOException {
        try (FileChannel fc = FileChannel.open(this.file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.writeImage(fc);
        }
        ((ScreenshotSaveCallback)ScreenshotSaveCallback.EVENT.invoker()).onSaved(this.file);
    }

    private void writeImage(FileChannel fc) throws IOException {
        Dimension dim = this.fbc.getCaptureDimension();
        try (WriteCallback callback = new WriteCallback(fc);){
            switch (Config.CAPTURE_FILE_FORMAT) {
                case PNG: {
                    STBImageWrite.stbi_write_png_to_func((STBIWriteCallbackI)callback, (long)0L, (int)dim.width(), (int)dim.height(), (int)this.fbc.getChannelCount(), (ByteBuffer)this.fbc.getDataBuffer(), (int)0);
                    break;
                }
                case JPG: {
                    STBImageWrite.stbi_write_jpg_to_func((STBIWriteCallbackI)callback, (long)0L, (int)dim.width(), (int)dim.height(), (int)this.fbc.getChannelCount(), (ByteBuffer)this.fbc.getDataBuffer(), (int)90);
                    break;
                }
                case TGA: {
                    STBImageWrite.stbi_write_tga_to_func((STBIWriteCallbackI)callback, (long)0L, (int)dim.width(), (int)dim.height(), (int)this.fbc.getChannelCount(), (ByteBuffer)this.fbc.getDataBuffer());
                    break;
                }
                case BMP: {
                    STBImageWrite.stbi_write_bmp_to_func((STBIWriteCallbackI)callback, (long)0L, (int)dim.width(), (int)dim.height(), (int)this.fbc.getChannelCount(), (ByteBuffer)this.fbc.getDataBuffer());
                }
            }
            if (callback.exception != null) {
                throw callback.exception;
            }
        }
    }

    private static class WriteCallback
    extends STBIWriteCallback
    implements AutoCloseable,
    Closeable {
        private final WritableByteChannel channel;
        private IOException exception;

        private WriteCallback(WritableByteChannel channel) {
            this.channel = channel;
        }

        public void invoke(long context, long data, int size) {
            if (this.exception != null) {
                return;
            }
            ByteBuffer buf = STBIWriteCallback.getData((long)data, (int)size);
            try {
                this.channel.write(buf);
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        @Override
        public void close() {
            this.free();
        }
    }
}

