/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import com.google.common.base.MoreObjects;
import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.mixins.ILivingEntity;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.MotionTracker;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.util.Lerp;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.AssociationPool;
import eu.ha3.presencefootsteps.world.BiomeVarianceLookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_5321;
import net.minecraft.class_745;
import org.jetbrains.annotations.Nullable;

class TerrestrialStepSoundGenerator
implements StepSoundGenerator {
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected boolean isAirborne;
    protected float lastFallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected long immobilePlayback;
    protected int immobileInterval;
    protected boolean isRightFoot;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    private boolean stepThisFrame;
    private boolean isMessyFoliage;
    private long brushesTime;
    protected final class_1309 entity;
    protected final SoundEngine engine;
    private final Modifier<TerrestrialStepSoundGenerator> modifier;
    protected final MotionTracker motionTracker = new MotionTracker(this);
    protected final AssociationPool associations;
    private final Lerp biomePitch = new Lerp();
    private final Lerp biomeVolume = new Lerp();

    public TerrestrialStepSoundGenerator(class_1309 entity, SoundEngine engine, Modifier<TerrestrialStepSoundGenerator> modifier) {
        this.entity = entity;
        this.engine = engine;
        this.modifier = modifier;
        this.associations = new AssociationPool(entity, engine);
    }

    @Override
    public float getLocalPitch(float tickDelta) {
        return this.biomePitch.get(tickDelta);
    }

    @Override
    public float getLocalVolume(float tickDelta) {
        return this.biomeVolume.get(tickDelta);
    }

    @Override
    public MotionTracker getMotionTracker() {
        return this.motionTracker;
    }

    @Override
    public void generateFootsteps() {
        BiomeVarianceLookup.BiomeVariance variance = this.entity.method_37908().method_23753(this.entity.method_24515()).method_40230().map(class_5321::method_29177).map(key -> this.engine.getIsolator().biomes().lookup((class_2960)key)).orElse(BiomeVarianceLookup.BiomeVariance.DEFAULT);
        this.biomePitch.update(variance.pitch(), 0.01f);
        this.biomeVolume.update(variance.volume(), 0.01f);
        this.motionTracker.simulateMotionData(this.entity);
        this.simulateFootsteps();
        this.simulateAirborne();
        this.simulateBrushes();
        this.simulateStationary();
        this.lastFallDistance = this.entity.field_6017;
    }

    protected void simulateStationary() {
        Association assos;
        if (!(!this.isImmobile || !this.entity.method_24828() && this.entity.method_5869() || !this.playbackImmobile() || !(assos = this.associations.findAssociation(0.0, this.isRightFoot)).isResult() || assos.isSilent() && this.isImmobile)) {
            this.playStep(assos, State.STAND);
        }
    }

    protected boolean playbackImmobile() {
        long now = System.currentTimeMillis();
        Variator variator = this.engine.getIsolator().variator();
        if (now - this.immobilePlayback > (long)this.immobileInterval) {
            this.immobilePlayback = now;
            this.immobileInterval = (int)Math.floor(Math.random() * (double)(variator.IMOBILE_INTERVAL_MAX - variator.IMOBILE_INTERVAL_MIN) + (double)variator.IMOBILE_INTERVAL_MIN);
            return true;
        }
        return false;
    }

    protected boolean updateImmobileState(float reference) {
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = System.currentTimeMillis();
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return System.currentTimeMillis() - this.timeImmobile > (long)this.engine.getIsolator().variator().IMMOBILE_DURATION;
        }
        return false;
    }

    protected void simulateFootsteps() {
        double movZ;
        double movX;
        double scal;
        if (!(this.entity instanceof class_1657)) {
            this.entity.field_5994 += (float)Math.sqrt(this.motionTracker.getHorizontalSpeed()) * 0.6f;
        }
        float distanceReference = this.entity.field_5994;
        this.stepThisFrame = false;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = this.motionTracker.getMotionX()) * this.xMovec + (movZ = this.motionTracker.getMotionZ()) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.engine.getIsolator().variator().PLAY_WANDER && !this.hasStoppingConditions()) {
                this.playStep(this.associations.findAssociation(0.0, this.isRightFoot), State.WANDER);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        float dwm = distanceReference - this.dmwBase;
        boolean immobile = this.updateImmobileState(distanceReference);
        if (immobile && !this.entity.method_6101()) {
            dwm = 0.0f;
            this.dmwBase = distanceReference;
        }
        if (this.entity.method_24828() || this.entity.method_5869() || this.entity.method_6101()) {
            State event = null;
            float distance = 0.0f;
            double verticalOffsetAsMinus = 0.0;
            Variator variator = this.engine.getIsolator().variator();
            if (this.entity.method_6101() && !this.entity.method_24828()) {
                distance = variator.DISTANCE_LADDER;
            } else if (!this.entity.method_5869() && Math.abs(this.yPosition - this.entity.method_23318()) > 0.4) {
                if (this.yPosition < this.entity.method_23318()) {
                    distance = variator.DISTANCE_STAIR;
                    event = this.motionTracker.pickState(this.entity, State.UP, State.UP_RUN);
                } else if (!this.entity.method_5715()) {
                    distance = -1.0f;
                    verticalOffsetAsMinus = 0.0;
                    event = this.motionTracker.pickState(this.entity, State.DOWN, State.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = variator.DISTANCE_HUMAN;
            }
            if (event == null) {
                event = this.motionTracker.pickState(this.entity, State.WALK, State.RUN);
            }
            if (this.entity instanceof class_1496 && this.motionTracker.getHorizontalSpeed() > 0.1) {
                distance *= 3.0f;
            }
            distance = this.modifier.reevaluateDistance(event, distance);
            if (dwm > (distance *= (PlayerUtil.getScale(this.entity) - 1.0f) * 0.6f + 1.0f)) {
                this.produceStep(event, verticalOffsetAsMinus);
                this.modifier.stepped(this, this.entity, event);
                this.dmwBase = distanceReference;
            }
        }
        if (this.entity.method_24828()) {
            this.yPosition = this.entity.method_23318();
        }
    }

    public final void produceStep(@Nullable State event) {
        this.produceStep(event, 0.0);
    }

    public final void produceStep(@Nullable State event, double verticalOffsetAsMinus) {
        if (event == null) {
            event = this.motionTracker.pickState(this.entity, State.WALK, State.RUN);
        }
        if (this.hasStoppingConditions()) {
            float volume = Math.min(1.0f, (float)this.entity.method_18798().method_1033() * 0.35f);
            this.engine.getIsolator().acoustics().playAcoustic(this.entity, this.entity.method_5799() ? SoundsKey.SWIM_WATER : SoundsKey.SWIM_LAVA, this.entity.method_5869() || this.entity.method_5777(class_3486.field_15518) ? State.SWIM : event, Options.singular("gliding_volume", volume).and(Options.singular("volume_scale", PlayerUtil.isClientPlayer((class_1297)this.entity) ? 1.0f : 0.125f)));
            this.playStep(this.associations.findAssociation(this.entity.method_24515().method_10074(), "find_messy_foliage"), event);
        } else {
            if (!this.entity.method_21751() || event.isExtraLoud()) {
                this.playStep(this.associations.findAssociation(verticalOffsetAsMinus, this.isRightFoot), event);
            }
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected boolean hasStoppingConditions() {
        return this.entity.method_5799() || this.entity.method_5771();
    }

    protected void simulateAirborne() {
        if ((this.entity.method_24828() || this.entity.method_6101()) == this.isAirborne) {
            this.isAirborne = !this.isAirborne;
            this.simulateJumpingLanding();
        }
    }

    protected boolean isJumping() {
        return ((ILivingEntity)this.entity).isJumping();
    }

    protected double getOffsetMinus() {
        if (this.entity instanceof class_745) {
            return 1.0;
        }
        return 0.0;
    }

    protected void simulateJumpingLanding() {
        if (this.hasStoppingConditions()) {
            return;
        }
        if (this.isAirborne && this.isJumping()) {
            this.simulateJumping();
        } else if (!this.isAirborne) {
            this.simulateLanding();
        }
    }

    protected void simulateJumping() {
        Variator variator = this.engine.getIsolator().variator();
        if (variator.EVENT_ON_JUMP) {
            if (this.motionTracker.getHorizontalSpeed() < (double)variator.SPEED_TO_JUMP_AS_MULTIFOOT) {
                this.playMultifoot(this.getOffsetMinus() + 0.4, State.WANDER);
            } else {
                this.playSinglefoot(this.getOffsetMinus() + 0.4, State.JUMP, this.isRightFoot);
            }
        }
    }

    protected void simulateLanding() {
        Variator variator = this.engine.getIsolator().variator();
        if (this.lastFallDistance > 0.0f) {
            if (this.lastFallDistance > variator.LAND_HARD_DISTANCE_MIN) {
                this.playMultifoot(this.getOffsetMinus(), State.LAND);
            } else if (!this.stepThisFrame && !this.entity.method_5715()) {
                this.playSinglefoot(this.getOffsetMinus(), this.motionTracker.pickState(this.entity, State.CLIMB, State.CLIMB_RUN), this.isRightFoot);
                if (!this.stepThisFrame) {
                    this.isRightFoot = !this.isRightFoot;
                }
            }
        }
    }

    private void simulateBrushes() {
        if (this.brushesTime > System.currentTimeMillis()) {
            return;
        }
        this.brushesTime = System.currentTimeMillis() + 100L;
        if (this.motionTracker.isStationary() || this.entity.method_5715() || !this.entity.method_6118(class_1304.field_6166).method_7960()) {
            return;
        }
        Association assos = this.associations.findAssociation(class_2338.method_49637((double)this.entity.method_23317(), (double)(((class_1297)MoreObjects.firstNonNull((Object)this.entity.method_5668(), (Object)this.entity)).method_23318() - 0.1 - (this.entity.method_24828() ? 0.0 : 0.25)), (double)this.entity.method_23321()), "find_messy_foliage");
        if (!assos.isSilent()) {
            if (!this.isMessyFoliage) {
                this.isMessyFoliage = true;
                this.playStep(assos, State.WALK);
            }
        } else if (this.isMessyFoliage) {
            this.isMessyFoliage = false;
        }
    }

    protected void playStep(Association association, State eventType) {
        class_1792 class_17922;
        if (this.engine.getConfig().getEnabledFootwear() && (class_17922 = this.entity.method_6118(class_1304.field_6166).method_7909()) instanceof class_1738) {
            class_1738 bootItem = (class_1738)class_17922;
            SoundsKey bootSound = this.engine.getIsolator().primitives().getAssociation((class_3414)bootItem.method_31570().comp_349(), "");
            if (bootSound.isEmitter()) {
                this.engine.getIsolator().acoustics().playStep(association, eventType, Options.singular("volume_percentage", 0.5f));
                this.engine.getIsolator().acoustics().playAcoustic(this.entity, bootSound, eventType, Options.EMPTY);
                return;
            }
        }
        this.engine.getIsolator().acoustics().playStep(association, eventType, Options.EMPTY);
    }

    protected void playSinglefoot(double verticalOffsetAsMinus, State eventType, boolean foot) {
        Association assos = this.associations.findAssociation(verticalOffsetAsMinus, this.isRightFoot);
        if (!assos.isResult()) {
            assos = this.associations.findAssociation(verticalOffsetAsMinus + 1.0, this.isRightFoot);
        }
        this.playStep(assos, eventType);
    }

    protected void playMultifoot(double verticalOffsetAsMinus, State eventType) {
        Association leftFoot = this.associations.findAssociation(verticalOffsetAsMinus, false);
        Association rightFoot = this.associations.findAssociation(verticalOffsetAsMinus, true);
        if (leftFoot.isResult() && leftFoot.dataEquals(rightFoot)) {
            if (this.isRightFoot) {
                leftFoot = Association.NOT_EMITTER;
            } else {
                rightFoot = Association.NOT_EMITTER;
            }
        }
        this.playStep(leftFoot, eventType);
        this.playStep(rightFoot, eventType);
    }
}

