/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.particles.systems;

import io.wispforest.endec.Endec;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.particles.systems.ParticleSystemExecutor;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ServicesFrozenException;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ParticleSystem<T> {
    private final ParticleSystemController manager;
    final Class<T> dataClass;
    final int index;
    final Endec<T> endec;
    ParticleSystemExecutor<T> handler;
    private final boolean permitsContextlessExecution;

    ParticleSystem(ParticleSystemController manager, Class<T> dataClass, int index, Endec<T> endec, ParticleSystemExecutor<T> handler) {
        OwoFreezer.checkRegister("Particle systems");
        this.manager = manager;
        this.dataClass = dataClass;
        this.index = index;
        this.endec = endec;
        this.handler = handler;
        this.permitsContextlessExecution = dataClass == Void.class;
    }

    public void setHandler(ParticleSystemExecutor<T> handler) {
        if (OwoFreezer.isFrozen()) {
            throw new ServicesFrozenException("Particle systems can only be changed during mod init");
        }
        if (this.handler != null) {
            throw new NetworkException("Particle system already has a handler");
        }
        this.handler = handler;
    }

    public void spawn(class_1937 world, class_243 pos, @Nullable T data) {
        if (data == null && !this.permitsContextlessExecution) {
            throw new IllegalStateException("This particle system does not permit 'null' data");
        }
        if (world.field_9236) {
            this.handler.executeParticleSystem(world, pos, data);
        } else {
            this.manager.sendPacket(this, (class_3218)world, pos, data);
        }
    }

    public void spawn(class_1937 world, class_243 pos) {
        this.spawn(world, pos, null);
    }
}

