/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.util;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import dev.lambdaurora.spruceui.util.ColorUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_863;

@Environment(value=EnvType.CLIENT)
public class DynamicLightLevelDebugRenderer
extends DynamicLightDebugRenderer {
    private final DynamicLightingEngine lightingEngine;

    public DynamicLightLevelDebugRenderer(LambDynLights mod) {
        super(mod);
        this.lightingEngine = mod.engine;
    }

    public void method_23109(class_4587 matrices, class_4597 bufferSource, double x, double y, double z) {
        int lightDisplayRadius = this.config.getDebugLightLevelRadius();
        if (lightDisplayRadius == 0) {
            return;
        }
        int startX = this.client.field_1724.method_24515().method_10263();
        int startY = this.client.field_1724.method_24515().method_10264();
        int startZ = this.client.field_1724.method_24515().method_10260();
        class_2338.class_2339 pos = new class_2338.class_2339();
        if (lightDisplayRadius > 0) {
            for (int offsetX = 0; offsetX < lightDisplayRadius * 2 + 1; ++offsetX) {
                for (int offsetY = 0; offsetY < lightDisplayRadius * 2 + 1; ++offsetY) {
                    for (int offsetZ = 0; offsetZ < lightDisplayRadius * 2 + 1; ++offsetZ) {
                        int green;
                        int red;
                        int currentX = startX + offsetX - lightDisplayRadius;
                        int currentY = startY + offsetY - lightDisplayRadius;
                        int currentZ = startZ + offsetZ - lightDisplayRadius;
                        pos.method_10103(currentX, currentY, currentZ);
                        double light = this.lightingEngine.getDynamicLightLevel((class_2338)pos);
                        if (light <= 0.05) continue;
                        if (light < 7.5) {
                            red = 255;
                            green = (int)class_3532.method_16436((double)(light / 7.5), (double)0.0, (double)255.0);
                        } else {
                            red = (int)class_3532.method_16436((double)((light - 7.5) / 7.5), (double)255.0, (double)0.0);
                            green = 255;
                        }
                        class_863.method_23106((class_4587)matrices, (class_4597)bufferSource, (String)"%.1f".formatted(light), (double)((double)currentX + 0.5), (double)((double)currentY + 0.5), (double)((double)currentZ + 0.5), (int)ColorUtil.packARGBColor((int)red, (int)green, (int)0, (int)255), (float)0.015f);
                    }
                }
            }
        }
    }
}

