/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Bobby/Mixin");
    private final boolean hasSodium = FabricLoader.getInstance().isModLoaded("sodium");
    private final boolean hasSodium05 = this.hasSodium && MixinConfigPlugin.hasClass("me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTrackerHolder");
    private final boolean hasSodium06;
    private final boolean hasStarlight;

    public MixinConfigPlugin() {
        boolean bl = this.hasSodium06 = this.hasSodium && MixinConfigPlugin.hasClass("net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTrackerHolder");
        if (this.hasSodium && !this.hasSodium05 && !this.hasSodium06) {
            LOGGER.error("Sodium version appears to be neither compatible with 0.5 nor 0.6");
        }
        this.hasStarlight = FabricLoader.getInstance().isModLoaded("starlight");
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!this.hasStarlight && targetClassName.startsWith("ca.spottedleaf.starlight.")) {
            return false;
        }
        if (mixinClassName.contains(".sodium05.")) {
            return this.hasSodium05;
        }
        if (mixinClassName.contains(".sodium06.")) {
            return this.hasSodium06;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static boolean hasClass(String name) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception checking whether class exists:", (Throwable)e);
            return false;
        }
    }
}

