/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CommonNetwork {
    public static String readString(ByteBuffer buf) {
        int len = buf.getInt();
        if (len <= 0) {
            return null;
        }
        byte[] b = new byte[len];
        buf.get(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static void writeString(ByteBuffer buf, String str) {
        if (str == null || str.isBlank()) {
            buf.putInt(0);
            return;
        }
        byte[] b = str.getBytes(StandardCharsets.UTF_8);
        buf.putInt(b.length);
        buf.put(b);
    }

    public static int stringSize(String str) {
        int size = 4;
        if (str != null && !str.isBlank()) {
            size += str.getBytes(StandardCharsets.UTF_8).length;
        }
        return size;
    }

    public static UUID readUUID(ByteBuffer buf) {
        long a = buf.getLong();
        long b = buf.getLong();
        return new UUID(a, b);
    }

    public static void writeUUID(ByteBuffer buf, UUID uuid) {
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
    }

    public static <T> List<T> readList(ByteBuffer buf, Function<ByteBuffer, T> reader) {
        int count = buf.getInt();
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            list.add(reader.apply(buf));
        }
        return list;
    }

    public static <T> void writeList(ByteBuffer buf, List<T> elements, BiConsumer<ByteBuffer, T> writter) {
        if (elements == null) {
            buf.putInt(0);
            return;
        }
        buf.putInt(elements.size());
        for (T entry : elements) {
            writter.accept(buf, (ByteBuffer)entry);
        }
    }

    public static <T> int listSize(List<T> elements, Function<T, Integer> sizer) {
        int size = 4;
        if (elements == null) {
            return size;
        }
        for (T entry : elements) {
            size += sizer.apply(entry).intValue();
        }
        return size;
    }

    public static boolean readBoolean(ByteBuffer buf) {
        return buf.get() != 0;
    }

    public static void writeBoolean(ByteBuffer buf, boolean bool) {
        buf.put((byte)(bool ? 1 : 0));
    }
}

