/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.config.EmoteFixer;
import io.github.kosmx.emotes.server.config.ConfigSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3675;

public class ClientConfigSerializer
extends ConfigSerializer {
    @Override
    public SerializableConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ClientConfig config = (ClientConfig)super.deserialize(json, typeOfT, context);
        this.clientDeserialize(json.getAsJsonObject(), config);
        return config;
    }

    @Override
    public JsonElement serialize(SerializableConfig config, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject node = super.serialize(config, typeOfSrc, context).getAsJsonObject();
        if (config instanceof ClientConfig) {
            this.clientSerialize((ClientConfig)config, node);
        }
        return node;
    }

    @Override
    protected SerializableConfig newConfig() {
        return new ClientConfig();
    }

    private void clientDeserialize(JsonObject node, SerializableConfig sconfig) {
        ClientConfig config = (ClientConfig)sconfig;
        EmoteFixer emoteFixer = new EmoteFixer(config.configVersion);
        if (node.has("fastmenu")) {
            this.fastMenuDeserializer(node.get("fastmenu").getAsJsonObject(), config, emoteFixer);
        }
        if (node.has("keys")) {
            this.keyBindsDeserializer(node.get("keys"), config, emoteFixer);
        }
    }

    private void fastMenuDeserializer(JsonObject node, ClientConfig config, EmoteFixer fixer) {
        for (int j = 0; j != 10; ++j) {
            if (!node.has(Integer.toString(j))) continue;
            JsonElement subNode = node.get(Integer.toString(j));
            if (subNode.isJsonObject()) {
                for (int i = 0; i != 8; ++i) {
                    if (!node.get(Integer.toString(j)).getAsJsonObject().has(Integer.toString(i))) continue;
                    config.fastMenuEmotes[j][i] = fixer.getEmoteID(node.get(Integer.toString(j)).getAsJsonObject().get(Integer.toString(i)));
                }
                continue;
            }
            config.fastMenuEmotes[0][j] = fixer.getEmoteID(node.get(Integer.toString(j)));
        }
    }

    private void keyBindsDeserializer(JsonElement node, ClientConfig config, EmoteFixer fixer) {
        if (config.configVersion < 4) {
            this.oldKeyBindsSerializer(node.getAsJsonArray(), config, fixer);
        } else {
            for (Map.Entry element : node.getAsJsonObject().entrySet()) {
                String str = ((JsonElement)element.getValue()).getAsString();
                config.emoteKeyMap.put(UUID.fromString((String)element.getKey()), class_3675.method_15981((String)str));
            }
        }
    }

    private void oldKeyBindsSerializer(JsonArray node, ClientConfig config, EmoteFixer fixer) {
        for (JsonElement jsonElement : node) {
            JsonObject n = jsonElement.getAsJsonObject();
            String str = n.get("key").getAsString();
            config.emoteKeyMap.add((Pair<UUID, class_3675.class_306>)new Pair((Object)fixer.getEmoteID(n.get("id")), (Object)class_3675.method_15981((String)str)));
        }
    }

    private void clientSerialize(ClientConfig config, JsonObject node) {
        node.add("fastmenu", (JsonElement)this.fastMenuSerializer(config));
        node.add("keys", (JsonElement)this.keyBindsSerializer(config));
    }

    private JsonObject fastMenuSerializer(ClientConfig config) {
        JsonObject node = new JsonObject();
        for (int j = 0; j != 10; ++j) {
            if (config.fastMenuEmotes[j] == null) continue;
            JsonObject subNode = new JsonObject();
            for (int i = 0; i != 8; ++i) {
                if (config.fastMenuEmotes[j][i] == null) continue;
                subNode.addProperty(Integer.toString(i), config.fastMenuEmotes[j][i].toString());
                node.add(Integer.toString(j), (JsonElement)subNode);
            }
        }
        return node;
    }

    private JsonObject keyBindsSerializer(ClientConfig config) {
        JsonObject array = new JsonObject();
        for (Pair<UUID, class_3675.class_306> pair : config.emoteKeyMap) {
            array.addProperty(((UUID)pair.getLeft()).toString(), ((class_3675.class_306)pair.getRight()).method_1441());
        }
        return array;
    }
}

