/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import me.pepperbell.continuity.api.client.CtmProperties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;

public interface TileAmountValidator<T extends BaseCtmProperties> {
    public boolean validateTileAmount(int var1, T var2);

    public static <T extends BaseCtmProperties> CtmProperties.Factory<T> wrapFactory(CtmProperties.Factory<T> factory, TileAmountValidator<T> validator) {
        return (properties, resourceId, pack, packPriority, resourceManager, method) -> {
            BaseCtmProperties ctmProperties = (BaseCtmProperties)factory.createProperties(properties, resourceId, pack, packPriority, resourceManager, method);
            if (ctmProperties == null) {
                return null;
            }
            if (validator.validateTileAmount(ctmProperties.getTileAmount(), ctmProperties)) {
                return ctmProperties;
            }
            return null;
        };
    }

    public static class AtLeast<T extends BaseCtmProperties>
    implements TileAmountValidator<T> {
        protected final int targetAmount;

        public AtLeast(int targetAmount) {
            this.targetAmount = targetAmount;
        }

        @Override
        public boolean validateTileAmount(int amount, T properties) {
            if (amount >= this.targetAmount) {
                return true;
            }
            ContinuityClient.LOGGER.error("Method '" + ((BaseCtmProperties)properties).getMethod() + "' requires at least " + this.targetAmount + " tiles but only " + amount + " were provided in file '" + String.valueOf(((BaseCtmProperties)properties).getResourceId()) + "' in pack '" + ((BaseCtmProperties)properties).getPackId() + "'");
            return false;
        }
    }

    public static class Exactly<T extends BaseCtmProperties>
    implements TileAmountValidator<T> {
        protected final int targetAmount;

        public Exactly(int targetAmount) {
            this.targetAmount = targetAmount;
        }

        @Override
        public boolean validateTileAmount(int amount, T properties) {
            if (amount == this.targetAmount) {
                return true;
            }
            ContinuityClient.LOGGER.error("Method '" + ((BaseCtmProperties)properties).getMethod() + "' requires exactly " + this.targetAmount + " tiles but " + amount + " were provided in file '" + String.valueOf(((BaseCtmProperties)properties).getResourceId()) + "' in pack '" + ((BaseCtmProperties)properties).getPackId() + "'");
            return false;
        }
    }
}

