/*
 * Decompiled with CFR 0.152.
 */
package espy.ldu.command;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import espy.ldu.LocalDifficultyUtilities;
import espy.ldu.events.ChunkTaskManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

public class InhabitedTimeTask {
    public static int run(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int x1 = IntegerArgumentType.getInteger(ctx, (String)"x1");
        int z1 = IntegerArgumentType.getInteger(ctx, (String)"z1");
        int x2 = IntegerArgumentType.getInteger(ctx, (String)"x2");
        int z2 = IntegerArgumentType.getInteger(ctx, (String)"z2");
        class_3218 world = class_2181.method_9289(ctx, (String)"dimension");
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        class_2168 source = (class_2168)ctx.getSource();
        UUID playerId = Objects.requireNonNull(source.method_44023()).method_5667();
        int minChunkX = Math.min(x1, x2) >> 4;
        int maxChunkX = Math.max(x1, x2) >> 4;
        int minChunkZ = Math.min(z1, z2) >> 4;
        int chunkWidth = maxChunkX - minChunkX + 1;
        int maxChunkZ = Math.max(z1, z2) >> 4;
        int chunkHeight = maxChunkZ - minChunkZ + 1;
        int totalChunks = chunkWidth * chunkHeight;
        if (totalChunks > LocalDifficultyUtilities.CONFIG.serverConfig.regionMaxChunks) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Too many chunks selected (" + totalChunks + "). Please select a smaller area.")));
            return 0;
        }
        HashSet<class_1923> chunks = new HashSet<class_1923>();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                class_2818 chunk = world.method_14178().method_12126(cx, cz, false);
                if (chunk == null || chunk.method_12223()) continue;
                chunks.add(new class_1923(cx, cz));
            }
        }
        LocalDifficultyUtilities.LOGGER.info("Total Chunks Selected: {}", (Object)chunks.size());
        ChunkTaskManager.startTask(playerId, source, world, new ArrayList<class_1923>(chunks), time);
        return 1;
    }

    public static int cancel(CommandContext<class_2168> ctx) {
        UUID playerId = Objects.requireNonNull(((class_2168)ctx.getSource()).method_44023()).method_5667();
        return ChunkTaskManager.cancel(playerId, (class_2168)ctx.getSource()) ? 1 : 0;
    }
}

