/*
 * Decompiled with CFR 0.152.
 */
package fr.rader.timeless.mixin.oldworldmenu;

import fr.rader.timeless.config.TimelessConfig;
import fr.rader.timeless.features.oldworldmenu.Constants;
import fr.rader.timeless.features.oldworldmenu.MoreWorldOptionsComponent;
import java.util.List;
import net.minecraft.class_1267;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5235;
import net.minecraft.class_525;
import net.minecraft.class_5676;
import net.minecraft.class_7712;
import net.minecraft.class_8100;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_525.class})
public abstract class MixinCreateWorldScreen
extends class_437 {
    @Shadow
    @Final
    class_8100 field_42172;
    @Unique
    private MoreWorldOptionsComponent moreWorldOptionsComponent;
    @Unique
    private boolean isWorldOptionsToggled = false;
    @Unique
    private class_342 worldName;
    @Unique
    private class_2561 worldDirectoryName;
    @Unique
    private class_5676<class_8100.class_4539> gameModeButton;
    @Unique
    private class_8100.class_4539 nonDebugGameMode;
    @Unique
    private class_2561 gameModeHelp1;
    @Unique
    private class_2561 gameModeHelp2;
    @Unique
    private class_5676<class_1267> difficultyButton;
    @Unique
    private class_5676<Boolean> allowCheatsButton;
    @Unique
    private class_4185 dataPacksButton;
    @Unique
    private class_4185 gameRulesButton;
    @Unique
    private class_4185 moreWorldOptionsButton;
    @Unique
    private int halfWidth;

    @Shadow
    abstract void method_29694(class_7712 var1);

    @Shadow
    protected abstract void method_2736();

    @Shadow
    public abstract class_8100 method_48657();

    protected MixinCreateWorldScreen(class_2561 title) {
        super(title);
    }

    @Inject(method={"renderDarkening"}, at={@At(value="HEAD")}, cancellable=true)
    public void timeless$renderDarkening(class_332 context, CallbackInfo ci) {
        if (!TimelessConfig.get().useOldWorldMenu) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void timeless$render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!TimelessConfig.get().useOldWorldMenu) {
            return;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.halfWidth, 20, -1);
        int textPositionX = this.halfWidth - 100;
        if (this.isWorldOptionsToggled) {
            context.method_27535(this.field_22793, Constants.SEED_LABEL, textPositionX, 47, Constants.getTextColor());
            context.method_27535(this.field_22793, Constants.SEED_INFO_LABEL, textPositionX, 85, Constants.getTextColor());
            this.moreWorldOptionsComponent.render(context);
        } else {
            context.method_27535(this.field_22793, Constants.WORLD_NAME_LABEL, textPositionX, 47, Constants.getTextColor());
            context.method_27535(this.field_22793, this.worldDirectoryName, textPositionX, 85, Constants.getTextColor());
            context.method_27535(this.field_22793, this.gameModeHelp1, textPositionX -= 50, 122, Constants.getTextColor());
            context.method_27535(this.field_22793, this.gameModeHelp2, textPositionX, 134, Constants.getTextColor());
            if (!this.field_42172.method_48729()) {
                context.method_27535(this.field_22793, Constants.ALLOW_CHEATS_INFO_LABEL, textPositionX, 172, Constants.getTextColor());
            }
        }
        ci.cancel();
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void timeless$init(CallbackInfo ci) {
        if (!TimelessConfig.get().useOldWorldMenu) {
            return;
        }
        this.moreWorldOptionsComponent = new MoreWorldOptionsComponent();
        this.halfWidth = this.field_22789 / 2;
        this.worldName = new class_342(this.field_22793, this.halfWidth - 100, 60, 200, 20, Constants.WORLD_NAME_LABEL);
        this.worldName.method_1852(this.field_42172.method_48715());
        this.worldName.method_1863(this::setWorldName);
        int leftColumnX = this.halfWidth - 155;
        int rightColumnX = this.halfWidth + 5;
        this.gameModeButton = class_5676.method_32606(value -> value.field_42224).method_32620(List.of(class_8100.class_4539.field_20624, class_8100.class_4539.field_20625, class_8100.class_4539.field_20626)).method_32619((Object)this.field_42172.method_48721()).method_32617(leftColumnX, 100, 150, 20, Constants.GAME_MODE_LABEL, (button, gameMode) -> this.setGameMode((class_8100.class_4539)gameMode));
        this.field_42172.method_48712(creator -> {
            this.gameModeButton.method_32605((Object)this.field_42172.method_48721());
            this.gameModeButton.field_22763 = !this.field_42172.method_48729();
        });
        this.difficultyButton = class_5676.method_32606(class_1267::method_5463).method_32624((Object[])class_1267.values()).method_32619((Object)this.field_42172.method_48722()).method_32617(rightColumnX, 100, 150, 20, Constants.DIFFICULTY_TEXT, (button, difficulty) -> this.field_42172.method_48696(difficulty));
        this.field_42172.method_48712(creator -> {
            this.difficultyButton.method_32605((Object)this.field_42172.method_48722());
            this.difficultyButton.field_22763 = !this.field_42172.method_48723();
        });
        this.allowCheatsButton = class_5676.method_32613((boolean)this.field_42172.method_48724()).method_32617(leftColumnX, 151, 150, 20, Constants.ALLOW_CHEATS_TEXT, (button, allowCheats) -> this.field_42172.method_48713(allowCheats.booleanValue()));
        this.field_42172.method_48712(creator -> {
            this.allowCheatsButton.method_32605((Object)this.field_42172.method_48724());
            this.allowCheatsButton.field_22763 = !this.field_42172.method_48729() && !this.field_42172.method_48723();
        });
        this.dataPacksButton = class_4185.method_46430((class_2561)Constants.DATA_PACKS_TEXT, button -> this.method_29694(this.field_42172.method_48728().comp_1030())).method_46434(rightColumnX, 151, 150, 20).method_46431();
        this.gameRulesButton = class_4185.method_46430((class_2561)Constants.GAME_RULES_TEXT, button -> this.field_22787.method_1507((class_437)new class_5235(this.field_42172.method_48734().method_27325(), optional -> {
            this.field_22787.method_1507((class_437)this);
            optional.ifPresent(arg_0 -> ((class_8100)this.field_42172).method_48697(arg_0));
        }))).method_46434(leftColumnX, 185, 150, 20).method_46431();
        this.moreWorldOptionsButton = class_4185.method_46430((class_2561)Constants.MORE_WORLD_OPTIONS_TEXT, button -> this.toggleWorldOptionsVisibility()).method_46434(rightColumnX, 185, 150, 20).method_46431();
        class_4185 createNewWorldButton = class_4185.method_46430((class_2561)Constants.CREATE_NEW_WORLD_TEXT, button -> this.method_2736()).method_46434(leftColumnX, this.field_22790 - 28, 150, 20).method_46431();
        class_4185 cancelButton = class_4185.method_46430((class_2561)Constants.CANCEL_TEXT, button -> this.method_25419()).method_46434(rightColumnX, this.field_22790 - 28, 150, 20).method_46431();
        List<class_339> moreWorldOptionsElements = this.moreWorldOptionsComponent.init((class_525)this, this.field_22793);
        this.method_37063((class_364)this.worldName);
        this.method_37063((class_364)this.gameModeButton);
        this.method_37063((class_364)this.difficultyButton);
        this.method_37063((class_364)this.allowCheatsButton);
        this.method_37063((class_364)this.dataPacksButton);
        this.method_37063((class_364)this.gameRulesButton);
        this.method_37063((class_364)this.moreWorldOptionsButton);
        this.method_37063((class_364)createNewWorldButton);
        this.method_37063((class_364)cancelButton);
        moreWorldOptionsElements.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.updateWorldOptionsVisibility();
        this.method_48265((class_364)this.worldName);
        this.field_42172.method_48695();
        this.updateGameModeHelp(this.field_42172.method_48721());
        this.updateWorldDirectoryName();
        ci.cancel();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void timeless$keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!TimelessConfig.get().useOldWorldMenu) {
            return;
        }
        cir.setReturnValue((Object)super.method_25404(keyCode, scanCode, modifiers));
        cir.cancel();
    }

    @Inject(method={"initTabNavigation"}, at={@At(value="HEAD")}, cancellable=true)
    public void timeless$initTabNavigation(CallbackInfo ci) {
        if (!TimelessConfig.get().useOldWorldMenu) {
            return;
        }
        super.method_48640();
        ci.cancel();
    }

    @Unique
    private void setWorldName(String newWorldName) {
        this.field_42172.method_48710(newWorldName);
        this.updateWorldDirectoryName();
    }

    @Unique
    private void updateWorldDirectoryName() {
        this.worldDirectoryName = class_2561.method_43473().method_10852(Constants.WORLD_DIRECTORY_NAME_LABEL).method_27693(" ").method_27693(this.field_42172.method_49703());
    }

    @Unique
    private void setGameMode(class_8100.class_4539 gameMode) {
        this.field_42172.method_48704(gameMode);
        this.updateGameModeHelp(gameMode);
    }

    @Unique
    private void updateGameModeHelp(class_8100.class_4539 gameMode) {
        String gameModeName = gameMode.name().toLowerCase();
        if (gameModeName.equals("debug")) {
            gameModeName = "spectator";
        }
        this.gameModeHelp1 = class_2561.method_43471((String)("timeless.selectWorld.gameMode." + gameModeName + ".line1"));
        this.gameModeHelp2 = class_2561.method_43471((String)("timeless.selectWorld.gameMode." + gameModeName + ".line2"));
    }

    @Unique
    private void toggleWorldOptionsVisibility() {
        this.setWorldOptionsVisibility(!this.isWorldOptionsToggled);
    }

    @Unique
    private void updateWorldOptionsVisibility() {
        this.setWorldOptionsVisibility(this.isWorldOptionsToggled);
    }

    @Unique
    private void setWorldOptionsVisibility(boolean visible) {
        this.isWorldOptionsToggled = visible;
        this.gameModeButton.field_22764 = !visible;
        boolean bl = this.difficultyButton.field_22764 = !visible;
        if (this.moreWorldOptionsComponent.isDebug()) {
            this.dataPacksButton.field_22764 = false;
            this.gameModeButton.field_22763 = false;
            if (this.nonDebugGameMode == null) {
                this.nonDebugGameMode = (class_8100.class_4539)this.gameModeButton.method_32603();
            }
            this.allowCheatsButton.field_22764 = false;
            this.setGameMode(class_8100.class_4539.field_20627);
        } else {
            this.gameModeButton.field_22763 = true;
            if (this.nonDebugGameMode != null) {
                this.setGameMode(this.nonDebugGameMode);
            }
            this.allowCheatsButton.field_22764 = !visible;
            this.dataPacksButton.field_22764 = !visible;
        }
        this.moreWorldOptionsComponent.setVisibility(visible);
        this.worldName.method_1862(!visible);
        if (visible) {
            this.moreWorldOptionsButton.method_25355(Constants.DONE_TEXT);
        } else {
            this.moreWorldOptionsButton.method_25355(Constants.MORE_WORLD_OPTIONS_TEXT);
        }
        this.gameRulesButton.field_22764 = !visible;
    }
}

