/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.compat;

import dev.dediamondpro.chatshot.compat.ICompatHandler;
import dev.dediamondpro.chatshot.compat.ImmediatelyFastCompat;
import dev.dediamondpro.chatshot.compat.NoChatReportsCompat;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;

public class CompatCore {
    public static final CompatCore INSTANCE = new CompatCore();
    private final ConcurrentLinkedDeque<ICompatHandler> compatHandlers = new ConcurrentLinkedDeque();

    private CompatCore() {
        ArrayList<Supplier<ICompatHandler>> compatHandlerFactories = new ArrayList<Supplier<ICompatHandler>>(){
            {
                this.add(NoChatReportsCompat::new);
                this.add(ImmediatelyFastCompat::new);
            }
        };
        for (Supplier supplier : compatHandlerFactories) {
            try {
                this.compatHandlers.add((ICompatHandler)supplier.get());
            }
            catch (Throwable throwable) {}
        }
    }

    public int getButtonOffset() {
        int offset = 0;
        for (ICompatHandler handler : this.compatHandlers) {
            try {
                offset = Math.max(offset, handler.getButtonOffset());
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError ignored) {
                this.compatHandlers.remove(handler);
            }
            catch (Throwable throwable) {}
        }
        return offset;
    }

    public void drawChatHud() {
        for (ICompatHandler handler : this.compatHandlers) {
            try {
                handler.drawChatHud();
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError ignored) {
                this.compatHandlers.remove(handler);
            }
            catch (Throwable throwable) {}
        }
    }
}

