/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import squeek.appleskin.network.ExhaustionSyncPayload;
import squeek.appleskin.network.SaturationSyncPayload;

public class SyncHandler {
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    public static void init() {
        PayloadTypeRegistry.playS2C().register(ExhaustionSyncPayload.ID, ExhaustionSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SaturationSyncPayload.ID, SaturationSyncPayload.CODEC);
    }

    public static void onPlayerUpdate(class_3222 player) {
        Float lastSaturationLevel = lastSaturationLevels.get(player.method_5667());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.method_5667());
        float saturation = player.method_7344().method_7589();
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != saturation) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SaturationSyncPayload(saturation));
            lastSaturationLevels.put(player.method_5667(), Float.valueOf(saturation));
        }
        float exhaustionLevel = player.method_7344().method_35219();
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ExhaustionSyncPayload(exhaustionLevel));
            lastExhaustionLevels.put(player.method_5667(), Float.valueOf(exhaustionLevel));
        }
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        lastSaturationLevels.remove(player.method_5667());
        lastExhaustionLevels.remove(player.method_5667());
    }
}

