/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.BakedChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;

public class ChunkBuildBuffers {
    private final Reference2ReferenceOpenHashMap<TerrainRenderPass, BakedChunkModelBuilder> builders = new Reference2ReferenceOpenHashMap();
    private final ChunkVertexType vertexType;

    public ChunkBuildBuffers(ChunkVertexType vertexType) {
        this.vertexType = vertexType;
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            ChunkMeshBufferBuilder[] vertexBuffers = new ChunkMeshBufferBuilder[ModelQuadFacing.COUNT];
            for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
                vertexBuffers[facing] = new ChunkMeshBufferBuilder(this.vertexType, 131072);
            }
            this.builders.put((Object)pass, (Object)new BakedChunkModelBuilder(vertexBuffers));
        }
    }

    public void init(BuiltSectionInfo.Builder renderData, int sectionIndex) {
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.begin(renderData, sectionIndex);
        }
    }

    public ChunkModelBuilder get(Material material) {
        return (ChunkModelBuilder)this.builders.get((Object)material.pass);
    }

    public ChunkModelBuilder get(TerrainRenderPass pass) {
        return (ChunkModelBuilder)this.builders.get((Object)pass);
    }

    public BuiltSectionMeshParts createMesh(TerrainRenderPass pass, boolean forceUnassigned) {
        BakedChunkModelBuilder builder = (BakedChunkModelBuilder)this.builders.get((Object)pass);
        ArrayList<ByteBuffer> vertexBuffers = new ArrayList<ByteBuffer>();
        int[] vertexCounts = new int[ModelQuadFacing.COUNT];
        int vertexSum = 0;
        for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
            int ordinal = facing.ordinal();
            ChunkMeshBufferBuilder buffer = builder.getVertexBuffer(facing);
            if (buffer.isEmpty()) continue;
            vertexBuffers.add(buffer.slice());
            int bufferCount = buffer.count();
            if (!forceUnassigned) {
                vertexCounts[ordinal] = bufferCount;
            }
            vertexSum += bufferCount;
        }
        if (vertexSum == 0) {
            return null;
        }
        if (forceUnassigned) {
            vertexCounts[ModelQuadFacing.UNASSIGNED.ordinal()] = vertexSum;
        }
        NativeBuffer mergedBuffer = new NativeBuffer(vertexSum * this.vertexType.getVertexFormat().getStride());
        ByteBuffer mergedBufferBuilder = mergedBuffer.getDirectBuffer();
        for (ByteBuffer buffer : vertexBuffers) {
            mergedBufferBuilder.put(buffer);
        }
        return new BuiltSectionMeshParts(mergedBuffer, vertexCounts);
    }

    public void destroy() {
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.destroy();
        }
    }
}

