/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.util;

import foundationgames.enhancedblockentities.util.ExecutableRunnableHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public enum WorldUtil implements ClientTickEvents.EndWorldTick
{
    EVENT_LISTENER;

    public static final Map<class_4076, ExecutableRunnableHashSet> CHUNK_UPDATE_TASKS;
    private static final Map<class_5321<class_1937>, Long2ObjectMap<Runnable>> TIMED_TASKS;

    public static void rebuildChunk(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_310.method_1551().field_1769.method_8570((class_1922)world, pos, state, state, 8);
    }

    public static void rebuildChunkAndThen(class_1937 world, class_2338 pos, Runnable action) {
        CHUNK_UPDATE_TASKS.computeIfAbsent(class_4076.method_18682((class_2338)pos), k -> new ExecutableRunnableHashSet()).add(action);
        WorldUtil.rebuildChunk(world, pos);
    }

    public static void scheduleTimed(class_1937 world, long time, Runnable action) {
        TIMED_TASKS.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new Long2ObjectOpenHashMap()).put(time, (Object)action);
    }

    public void onEndTick(class_638 world) {
        class_5321 key = world.method_27983();
        if (TIMED_TASKS.containsKey(key)) {
            TIMED_TASKS.get(key).long2ObjectEntrySet().removeIf(entry -> {
                if (world.method_8510() >= entry.getLongKey()) {
                    ((Runnable)entry.getValue()).run();
                    return true;
                }
                return false;
            });
        }
    }

    static {
        CHUNK_UPDATE_TASKS = new HashMap<class_4076, ExecutableRunnableHashSet>();
        TIMED_TASKS = new HashMap<class_5321<class_1937>, Long2ObjectMap<Runnable>>();
    }
}

