/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.explosions.block_raycast;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5362;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
public abstract class ExplosionMixin {
    @Shadow
    @Final
    private float field_9190;
    @Shadow
    @Final
    private double field_9195;
    @Shadow
    @Final
    private double field_9192;
    @Shadow
    @Final
    private double field_9189;
    @Shadow
    @Final
    private class_1937 field_9187;
    @Shadow
    @Final
    private class_5362 field_25400;
    @Shadow
    @Final
    private boolean field_9186;
    private final class_2338.class_2339 cachedPos = new class_2338.class_2339();
    private int prevChunkX = Integer.MIN_VALUE;
    private int prevChunkZ = Integer.MIN_VALUE;
    private class_2791 prevChunk;
    private boolean explodeAirBlocks;
    private int bottomY;
    private int topY;

    @Inject(method={"<init>(Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;Lnet/minecraft/class_1282;Lnet/minecraft/class_5362;DDDFZLnet/minecraft/class_1927$class_4179;Lnet/minecraft/class_2394;Lnet/minecraft/class_2394;Lnet/minecraft/class_6880;)V"}, at={@At(value="TAIL")})
    private void init(class_1937 world, class_1297 entity, class_1282 damageSource, class_5362 behavior, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, class_2394 particle, class_2394 emitterParticle, class_6880<?> soundEvent, CallbackInfo ci) {
        this.bottomY = this.field_9187.method_31607();
        this.topY = this.field_9187.method_31600();
        boolean explodeAir = this.field_9186;
        if (!explodeAir && this.field_9187.method_27983() == class_1937.field_25181 && this.field_9187.method_40134().method_40225(class_7134.field_37668)) {
            float overestimatedExplosionRange = 8 + (int)(6.0f * this.field_9190);
            boolean endPortalX = false;
            boolean endPortalZ = false;
            if ((double)overestimatedExplosionRange > Math.abs(this.field_9195 - (double)endPortalX) && (double)overestimatedExplosionRange > Math.abs(this.field_9189 - (double)endPortalZ)) {
                explodeAir = true;
            }
        }
        this.explodeAirBlocks = explodeAir;
    }

    @Redirect(method={"method_8348()V"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Sets;newHashSet()Ljava/util/HashSet;", remap=false))
    public HashSet<class_2338> skipNewHashSet() {
        return null;
    }

    @ModifyConstant(method={"method_8348()V"}, constant={@Constant(intValue=16, ordinal=1)})
    public int skipLoop(int prevValue) {
        return 0;
    }

    @Redirect(method={"method_8348()V"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectArrayList;addAll(Ljava/util/Collection;)Z", remap=false))
    public boolean collectBlocks(ObjectArrayList<class_2338> affectedBlocks, Collection<class_2338> collection) {
        LongOpenHashSet touched = new LongOpenHashSet(0);
        class_5819 random = this.field_9187.field_9229;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        LongIterator it = touched.iterator();
        boolean added = false;
        while (it.hasNext()) {
            added |= affectedBlocks.add((Object)class_2338.method_10092((long)it.nextLong()));
        }
        return added;
    }

    @Unique
    private void performRayCast(class_5819 random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist * 0.3;
        double normY = vecY / dist * 0.3;
        double normZ = vecZ / dist * 0.3;
        float strength = this.field_9190 * (0.7f + random.method_43057() * 0.6f);
        double stepX = this.field_9195;
        double stepY = this.field_9192;
        double stepZ = this.field_9189;
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        int boundMinY = this.bottomY;
        int boundMaxY = this.topY;
        while (strength > 0.0f) {
            float resistance;
            int blockX = class_3532.method_15357((double)stepX);
            int blockY = class_3532.method_15357((double)stepY);
            int blockZ = class_3532.method_15357((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                if (blockY < boundMinY || blockY >= boundMaxY || blockX < -30000000 || blockZ < -30000000 || blockX >= 30000000 || blockZ >= 30000000) {
                    return;
                }
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance;
            strength -= 0.22500001f;
            stepX += normX;
            stepY += normY;
            stepZ += normZ;
        }
    }

    @Unique
    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        float reducedStrength;
        Optional blastResistance;
        class_2826 section;
        class_2338.class_2339 pos = this.cachedPos.method_10103(blockX, blockY, blockZ);
        int chunkX = Pos.ChunkCoord.fromBlockCoord(blockX);
        int chunkZ = Pos.ChunkCoord.fromBlockCoord(blockZ);
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.field_9187.method_8497(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        class_2791 chunk = this.prevChunk;
        class_2680 blockState = class_2246.field_10124.method_9564();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.method_12006()[Pos.SectionYIndex.fromBlockCoord((class_5539)chunk, blockY)]) != null && !section.method_38292() && (blockState = section.method_12254(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).method_26204() != class_2246.field_10124) {
            class_3610 fluidState = blockState.method_26227();
            blastResistance = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, blockState, fluidState);
        } else {
            blastResistance = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, class_2246.field_10124.method_9564(), class_3612.field_15906.method_15785());
        }
        if (blastResistance.isPresent()) {
            totalResistance = (((Float)blastResistance.get()).floatValue() + 0.3f) * 0.3f;
        }
        if ((reducedStrength = strength - totalResistance) > 0.0f && (this.explodeAirBlocks || !blockState.method_26215()) && this.field_25400.method_29554((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, blockState, reducedStrength)) {
            touched.add(pos.method_10063());
        }
        return totalResistance;
    }
}

