/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.inject.GreedyInputComponent;
import io.wispforest.owo.ui.util.DisposableScreen;
import io.wispforest.owo.ui.util.UIErrorToast;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOwoScreen<R extends ParentComponent>
extends class_437
implements DisposableScreen {
    protected OwoUIAdapter<R> uiAdapter = null;
    protected boolean invalid = false;

    protected BaseOwoScreen(class_2561 title) {
        super(title);
    }

    protected BaseOwoScreen() {
        this((class_2561)class_2561.method_43473());
    }

    @NotNull
    protected abstract OwoUIAdapter<R> createAdapter();

    protected abstract void build(R var1);

    protected void method_25426() {
        if (this.invalid) {
            return;
        }
        if (this.uiAdapter != null) {
            this.uiAdapter.moveAndResize(0, 0, this.field_22789, this.field_22790);
            this.method_37063(this.uiAdapter);
        } else {
            try {
                this.uiAdapter = this.createAdapter();
                this.build(this.uiAdapter.rootComponent);
                this.uiAdapter.inflateAndMount();
            }
            catch (Exception error) {
                Owo.LOGGER.warn("Could not initialize owo screen", (Throwable)error);
                UIErrorToast.report(error);
                this.invalid = true;
            }
        }
    }

    protected <C extends Component> C component(Class<C> expectedClass, String id) {
        return this.uiAdapter.rootComponent.childById(expectedClass, id);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.invalid) {
            super.method_25394(context, mouseX, mouseY, delta);
        } else {
            this.method_25419();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        GreedyInputComponent inputComponent;
        Component component;
        if (this.uiAdapter == null) {
            return false;
        }
        if ((modifiers & 2) == 0 && (component = this.uiAdapter.rootComponent.focusHandler().focused()) instanceof GreedyInputComponent && (inputComponent = (GreedyInputComponent)component).onKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.uiAdapter == null) {
            return false;
        }
        return this.uiAdapter.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Nullable
    public class_364 method_25399() {
        return this.uiAdapter;
    }

    public void method_25432() {
        if (this.uiAdapter != null) {
            this.uiAdapter.cursorAdapter.applyStyle(CursorStyle.NONE);
        }
    }

    @Override
    public void dispose() {
        if (this.uiAdapter != null) {
            this.uiAdapter.dispose();
        }
    }
}

