/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import java.awt.Color;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.lib.mod.client.render.shader.SolidColorShader;
import su.plo.slib.api.chat.component.McTextComponent;

public final class TabButton
extends Button {
    private final boolean shadow;
    private final Color shadowColor;
    private final class_2960 iconLocation;
    private final class_2960 disabledIconLocation;

    public TabButton(int x, int y, int width, int height, @NotNull McTextComponent text, @NotNull class_2960 iconLocation, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, boolean shadow) {
        this(x, y, width, height, text, iconLocation, pressAction, tooltipAction, shadow, Colors.WHITE);
    }

    public TabButton(int x, int y, int width, int height, @NotNull McTextComponent text, @NotNull class_2960 iconLocation, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, boolean shadow, Color shadowColor) {
        super(x, y, width, height, text, pressAction, tooltipAction);
        this.shadow = shadow;
        this.shadowColor = shadowColor;
        this.iconLocation = iconLocation;
        this.disabledIconLocation = ResourceLocationUtil.tryBuild(iconLocation.method_12836(), iconLocation.method_12832().replace(".png", "_disabled.png"));
    }

    @Override
    protected void renderText(@NotNull GuiRenderContext context, int mouseX, int mouseY) {
        if (this.shadow && SolidColorShader.isAvailable()) {
            Color shadowColor = this.active ? this.shadowColor : Colors.GRAY;
            context.blitColor(this.getIconLocation(), this.x + 7, this.y + 7, 0.0f, 0.0f, 8, 8, 8, 8, Colors.times(shadowColor, 0.25), RenderPipelines.GUI_TEXTURE_SOLID_COLOR);
        }
        context.blit(this.getIconLocation(), this.x + 6, this.y + 6, 0.0f, 0.0f, 8, 8, 8, 8);
        Color textColor = this.active ? Colors.WHITE : Colors.GRAY;
        context.drawString(this.getText(), this.x + 16, this.y + (this.height - 8) / 2, Colors.withAlpha(textColor, this.alpha), true);
    }

    private class_2960 getIconLocation() {
        return this.active ? this.iconLocation : this.disabledIconLocation;
    }
}

