/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class GeyserEmotePacket {
    private long runtimeEntityID;
    private UUID emoteID;

    public void read(byte[] bytes) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        this.runtimeEntityID = 0L;
        byte[] str = new byte[byteBuffer.get()];
        byteBuffer.get(str);
        this.emoteID = UUID.fromString(new String(str, StandardCharsets.UTF_8));
    }

    public byte[] write() throws IOException {
        byte[] bytes = this.emoteID.toString().getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length + 1 + 8);
        byteBuffer.put((byte)bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.putLong(this.runtimeEntityID);
        return byteBuffer.array();
    }

    public long getRuntimeEntityID() {
        return this.runtimeEntityID;
    }

    public void setEmoteID(UUID emoteID) {
        this.emoteID = emoteID;
    }

    public UUID getEmoteID() {
        return this.emoteID;
    }

    public void setRuntimeEntityID(long runtimeEntityID) {
        this.runtimeEntityID = runtimeEntityID;
    }
}

