/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.util;

import dev.dediamondpro.chatshot.compat.CompatCore;
import dev.dediamondpro.chatshot.config.Config;
import dev.dediamondpro.chatshot.util.CollectingCharacterVisitor;
import dev.dediamondpro.chatshot.util.clipboard.ClipboardUtil;
import dev.dediamondpro.chatshot.util.clipboard.MacOSCompat;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_332;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6367;
import org.lwjgl.glfw.GLFW;

public class ChatCopyUtil {
    public static void copy(List<class_303.class_7590> lines, class_310 client) {
        if (GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)340) == 1 || GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)344) == 1) {
            if (Config.INSTANCE.shiftClickAction == Config.CopyType.TEXT) {
                ChatCopyUtil.copyString(lines, client);
            } else {
                ChatCopyUtil.copyImage(lines, client);
            }
        } else if (Config.INSTANCE.clickAction == Config.CopyType.TEXT) {
            ChatCopyUtil.copyString(lines, client);
        } else {
            ChatCopyUtil.copyImage(lines, client);
        }
    }

    public static void copyString(List<class_303.class_7590> lines, class_310 client) {
        CollectingCharacterVisitor visitor = new CollectingCharacterVisitor();
        for (class_303.class_7590 line : lines) {
            line.comp_896().accept((class_5224)visitor);
        }
        client.field_1774.method_1455(visitor.collect());
        if (Config.INSTANCE.showCopyMessage) {
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"chatshot.text.success"));
        }
    }

    public static void copyImage(List<class_303.class_7590> lines, class_310 client) {
        class_276 fb;
        boolean shadow = Config.INSTANCE.shadow;
        int scaleFactor = Config.INSTANCE.scale;
        CompatCore.INSTANCE.drawChatHud();
        class_332 context = new class_332(client, client.method_22940().method_23000());
        int width = 0;
        for (class_303.class_7590 line : lines) {
            class_5481 content = line.comp_896();
            width = Math.max(width, client.field_1772.method_30880(content));
        }
        int height = lines.size() * 9;
        try {
            fb = ChatCopyUtil.createBuffer(width * scaleFactor, height * scaleFactor);
        }
        catch (IllegalArgumentException e) {
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"chatshot.noMessageFound"));
            return;
        }
        context.method_51448().method_22905((float)client.method_22683().method_4486() / (float)width, (float)client.method_22683().method_4502() / (float)height, 1.0f);
        fb.method_1235(false);
        int y = 0;
        for (class_303.class_7590 line : lines) {
            class_5481 content = line.comp_896();
            context.method_51430(client.field_1772, content, 0, y, 0xFFFFFF, shadow);
            y += 9;
        }
        CompatCore.INSTANCE.drawChatHud();
        fb.method_1240();
        try (class_1011 nativeImage = class_318.method_1663((class_276)fb);){
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(nativeImage.method_24036()));
            BufferedImage transparentImage = ChatCopyUtil.imageToBufferedImage(ChatCopyUtil.makeColorTransparent(image, new Color(54, 57, 63)));
            boolean copySuccessfull = false;
            if (Config.INSTANCE.saveImage || class_310.field_1703) {
                File screenShotDir = new File("screenshots/chat");
                screenShotDir.mkdirs();
                File screenshotFile = ChatCopyUtil.getScreenshotFilename(screenShotDir);
                ImageIO.write((RenderedImage)transparentImage, "png", screenshotFile);
                if (class_310.field_1703) {
                    copySuccessfull = MacOSCompat.doCopyMacOS(screenshotFile.getAbsolutePath());
                    if (!Config.INSTANCE.saveImage) {
                        screenshotFile.delete();
                    }
                }
            }
            if (!class_310.field_1703) {
                copySuccessfull = ClipboardUtil.copy(transparentImage);
            }
            class_5250 message = null;
            if (copySuccessfull) {
                if (Config.INSTANCE.showCopyMessage) {
                    message = class_2561.method_43471((String)"chatshot.image.success");
                }
            } else {
                message = class_2561.method_43471((String)"chatshot.image.fail");
            }
            if (message != null) {
                client.field_1705.method_1743().method_1812((class_2561)message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        client.method_1522().method_1235(true);
    }

    private static File getScreenshotFilename(File directory) {
        File file;
        String string = class_156.method_44893();
        int i = 1;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private static class_276 createBuffer(int width, int height) {
        class_6367 fb = new class_6367(width, height, true, false);
        fb.method_1236(0.21176471f, 0.22352941f, 0.24705882f, 0.0f);
        fb.method_1230(false);
        return fb;
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public final int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }
}

